using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Threading;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgPrintBackupForms
	/// </summary>
	public class DlgPrintBackupForms : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpSplit;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updNumberOfTags;
		private System.Windows.Forms.Label lblMessage;
		private System.Windows.Forms.Label lblNumberOfTags;
		private System.Windows.Forms.GroupBox grpIcon;
		private System.Windows.Forms.PictureBox picPrinter;
		private System.Windows.Forms.GroupBox grpPrintBackups;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updNumberOfForms;
		private System.Windows.Forms.Label lblNumberOfForms;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.PrintDialog printDialog1;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgPrintBackupForms()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			this.SetComponentProperties();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgPrintBackupForms));
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpPrintBackups = new System.Windows.Forms.GroupBox();
			this.updNumberOfForms = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblNumberOfForms = new System.Windows.Forms.Label();
			this.grpSplit = new System.Windows.Forms.GroupBox();
			this.updNumberOfTags = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblMessage = new System.Windows.Forms.Label();
			this.lblNumberOfTags = new System.Windows.Forms.Label();
			this.grpIcon = new System.Windows.Forms.GroupBox();
			this.picPrinter = new System.Windows.Forms.PictureBox();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.printDialog1 = new System.Windows.Forms.PrintDialog();
			this.grpPrintBackups.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updNumberOfForms)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updNumberOfTags)).BeginInit();
			this.grpIcon.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(362, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Print Backup Forms";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 179);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(284, 161);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Close";
			// 
			// grpPrintBackups
			// 
			this.grpPrintBackups.AccessibleDescription = "Print backup forms for use during system downtime.";
			this.grpPrintBackups.AccessibleName = "Print backup forms for use during system downtime.";
			this.grpPrintBackups.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpPrintBackups.Controls.Add(this.updNumberOfForms);
			this.grpPrintBackups.Controls.Add(this.lblNumberOfForms);
			this.grpPrintBackups.Controls.Add(this.grpSplit);
			this.grpPrintBackups.Controls.Add(this.updNumberOfTags);
			this.grpPrintBackups.Controls.Add(this.lblMessage);
			this.grpPrintBackups.Controls.Add(this.lblNumberOfTags);
			this.grpPrintBackups.Location = new System.Drawing.Point(60, 32);
			this.grpPrintBackups.Name = "grpPrintBackups";
			this.grpPrintBackups.Size = new System.Drawing.Size(300, 121);
			this.grpPrintBackups.TabIndex = 0;
			this.grpPrintBackups.TabStop = false;
			// 
			// updNumberOfForms
			// 
			this.updNumberOfForms.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.updNumberOfForms.Location = new System.Drawing.Point(220, 92);
			this.updNumberOfForms.Maximum = new System.Decimal(new int[] {
																			 99,
																			 0,
																			 0,
																			 0});
			this.updNumberOfForms.Name = "updNumberOfForms";
			this.updNumberOfForms.Size = new System.Drawing.Size(64, 20);
			this.updNumberOfForms.TabIndex = 5;
			this.updNumberOfForms.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.ttToolTip.SetToolTip(this.updNumberOfForms, "This function is not available yet!");
			this.updNumberOfForms.Value = new System.Decimal(new int[] {
																		   0,
																		   0,
																		   0,
																		   0});
			this.updNumberOfForms.TextChanged += new System.EventHandler(this.updNumberOfForms_ValueChanged);
			this.updNumberOfForms.Leave += new System.EventHandler(this.updNumberOfForms_Leave);
			this.updNumberOfForms.ValueChanged += new System.EventHandler(this.updNumberOfForms_ValueChanged);
			// 
			// lblNumberOfForms
			// 
			this.lblNumberOfForms.Location = new System.Drawing.Point(8, 92);
			this.lblNumberOfForms.Name = "lblNumberOfForms";
			this.lblNumberOfForms.Size = new System.Drawing.Size(224, 20);
			this.lblNumberOfForms.TabIndex = 4;
			this.lblNumberOfForms.Text = "Print Unit Blood Transfusion Record Forms";
			this.lblNumberOfForms.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpSplit
			// 
			this.grpSplit.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSplit.Location = new System.Drawing.Point(8, 52);
			this.grpSplit.Name = "grpSplit";
			this.grpSplit.Size = new System.Drawing.Size(286, 7);
			this.grpSplit.TabIndex = 1;
			this.grpSplit.TabStop = false;
			// 
			// updNumberOfTags
			// 
			this.updNumberOfTags.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.updNumberOfTags.Location = new System.Drawing.Point(220, 64);
			this.updNumberOfTags.Maximum = new System.Decimal(new int[] {
																			99,
																			0,
																			0,
																			0});
			this.updNumberOfTags.Name = "updNumberOfTags";
			this.updNumberOfTags.Size = new System.Drawing.Size(64, 20);
			this.updNumberOfTags.TabIndex = 3;
			this.updNumberOfTags.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updNumberOfTags.Value = new System.Decimal(new int[] {
																		  0,
																		  0,
																		  0,
																		  0});
			this.updNumberOfTags.TextChanged += new System.EventHandler(this.updNumberOfTags_ValueChanged);
			this.updNumberOfTags.Leave += new System.EventHandler(this.updNumberOfTags_Leave);
			this.updNumberOfTags.ValueChanged += new System.EventHandler(this.updNumberOfTags_ValueChanged);
			// 
			// lblMessage
			// 
			this.lblMessage.AccessibleDescription = "Print backup forms for use during system downtime.";
			this.lblMessage.AccessibleName = "Print backup forms for use during system downtime.";
			this.lblMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblMessage.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblMessage.Location = new System.Drawing.Point(8, 12);
			this.lblMessage.Name = "lblMessage";
			this.lblMessage.Size = new System.Drawing.Size(288, 36);
			this.lblMessage.TabIndex = 0;
			this.lblMessage.Text = "Print backup forms for use during system downtime.";
			this.lblMessage.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// lblNumberOfTags
			// 
			this.lblNumberOfTags.Location = new System.Drawing.Point(8, 64);
			this.lblNumberOfTags.Name = "lblNumberOfTags";
			this.lblNumberOfTags.Size = new System.Drawing.Size(224, 20);
			this.lblNumberOfTags.TabIndex = 2;
			this.lblNumberOfTags.Text = "Print Unit Caution Tags";
			this.lblNumberOfTags.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpIcon
			// 
			this.grpIcon.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpIcon.Controls.Add(this.picPrinter);
			this.grpIcon.Location = new System.Drawing.Point(4, 32);
			this.grpIcon.Name = "grpIcon";
			this.grpIcon.Size = new System.Drawing.Size(52, 121);
			this.grpIcon.TabIndex = 4;
			this.grpIcon.TabStop = false;
			// 
			// picPrinter
			// 
			this.picPrinter.Image = ((System.Drawing.Image)(resources.GetObject("picPrinter.Image")));
			this.picPrinter.Location = new System.Drawing.Point(4, 12);
			this.picPrinter.Name = "picPrinter";
			this.picPrinter.Size = new System.Drawing.Size(45, 45);
			this.picPrinter.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picPrinter.TabIndex = 0;
			this.picPrinter.TabStop = false;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(204, 161);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			this.ttToolTip.SetToolTip(this.btnOK, "The number of tags must be greater than 0");
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// DlgPrintBackupForms
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(362, 195);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpPrintBackups);
			this.Controls.Add(this.grpIcon);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.hlphelpChm.SetHelpKeyword(this, "Print_Unit_Caution_Tag_&_Transfusion_Record_Form.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(368, 220);
			this.Name = "DlgPrintBackupForms";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Print Backup Forms";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgPrintBackupForms_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpIcon, 0);
			this.Controls.SetChildIndex(this.grpPrintBackups, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.grpPrintBackups.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updNumberOfForms)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updNumberOfTags)).EndInit();
			this.grpIcon.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region methods

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Print Backup Forms";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC044.DlgPrintBackupForms());
			//
			this.RequiredFieldsLabel = false;
		}

		#endregion
		
		
		#region events


		private void updNumberOfTags_ValueChanged(object sender, System.EventArgs e)
		{
			try
			{
				updNumberOfTags.Value = updNumberOfTags.Value;
				this.errError.SetVbecsError(updNumberOfTags, string.Empty); // **** 508 Compliance ***
			}
			catch(FormatException)
			{
				this.btnOK.EnabledButton = false;
			}
			this.CheckValid();
		}

		private void updNumberOfTags_Leave(object sender, EventArgs e)
		{
			try
			{
				updNumberOfTags.Value = updNumberOfTags.Value;
				this.errError.SetVbecsError(updNumberOfTags, string.Empty); // **** 508 Compliance ***
			}
			catch(FormatException err)
			{
				this.errError.SetVbecsError(updNumberOfTags, err.Message); // **** 508 Compliance ***
				this.btnOK.EnabledButton = false;
			}
			this.CheckValid();
		}

		private void updNumberOfForms_ValueChanged(object sender, System.EventArgs e)
		{
			try
			{
				updNumberOfForms.Value = updNumberOfForms.Value;
				this.errError.SetVbecsError(updNumberOfForms, string.Empty); // **** 508 Compliance ***
			}
			catch(FormatException)
			{
				this.btnOK.EnabledButton = false;
			}
			this.CheckValid();
		}

		private void updNumberOfForms_Leave(object sender, EventArgs e)
		{
			try
			{
				updNumberOfForms.Value = updNumberOfForms.Value;
				this.errError.SetVbecsError(updNumberOfForms, string.Empty); // **** 508 Compliance ***
			}
			catch(FormatException err)
			{
				this.errError.SetVbecsError(updNumberOfForms, err.Message); // **** 508 Compliance ***
				this.btnOK.EnabledButton = false;
			}
			this.CheckValid();
		}

		private void CheckValid()
		{
			try
			{
				//Deliberately using | instead of || because we need to evaluate both
				//conditions just in case one of them throws an exception.
				if (updNumberOfTags.Value > 0 | this.updNumberOfForms.Value > 0)
				{
					this.btnOK.EnabledButton = true;
					this.ttToolTip.SetToolTip(this.btnOK, string.Empty);
				}
				else
				{
					this.btnOK.EnabledButton = false;
					this.ttToolTip.SetToolTip(this.btnOK, Common.StrRes.Tooltips.UC043.NoTags().ResString);
				}
			}
			catch(FormatException)
			{
				this.btnOK.EnabledButton = false;
				this.ttToolTip.SetToolTip(this.btnOK, Common.StrRes.Tooltips.UC043.NoTags().ResString);
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			PrintBackups();
			
			this.Close();
		}

		private void PrintBackups()
		{
			try
			{
				if (this.updNumberOfTags.Value > 0)
				{
					BOL.Division division = new BOL.Division(Common.LogonUser.LogonUserDivisionCode);

					if (division.LabelPrinterConfig == null || division.LabelPrinterConfig.ListenerIPAddress == null ||
						division.LabelPrinterConfig.ListenerTcpPortNumber < 1 || division.LabelPrinterConfig.ListenerTcpPortNumber > 50000)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC003.CautionTagPrinterNotAvailable());
					}
					else
					{
						Common.LogonUser.PrintThreadCT = new Thread(new ThreadStart(PrintBlankCTs));
						Common.LogonUser.PrintThreadCT.Start();
					}
				}
				if (this.updNumberOfForms.Value > 0)
				{
					PrintBlankBTRFs();
				}
			}
			catch(Exception)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.PrintFailure());
			}
		}

		private void PrintBlankCTs()
		{
			int countCTs = 0;
			int tagCount = 0;	// number of tags to be printed
			int loopCount = 0;	// number of times loop has gone (prevent infinite loops)
			try
			{
				while (tagCount == 0 && loopCount <10)
				{
					try
					{
						tagCount = (int) this.updNumberOfTags.Value;
					}
					catch (System.FormatException)
					{
						loopCount++;
						Thread.Sleep(100);
					}
				}

				if (tagCount == 0) throw new BOL.BusinessObjectException();

				while (countCTs < tagCount)
				{
					BOL.CautionTag.PrintBlankCautionTag();
					countCTs++;
					Thread.Sleep(500);
				}
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.PrintSuccess());
			}
			catch(System.Threading.ThreadAbortException)
			{
				// BR_43.12
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.CTPrintingInterrupted(countCTs));
			}
		}

		private void PrintBlankBTRFs()
		{
			int countBTRFs = 0;
			try
			{
				// Blood Transfusion Record Forms
				System.Drawing.Printing.PrinterSettings settings = new System.Drawing.Printing.PrinterSettings();
				printDialog1.PrinterSettings = settings;

				if (printDialog1.ShowDialog(this) == DialogResult.OK)
				{		
                    ReportDataSource reportSourceMain = new ReportDataSource();
                    reportSourceMain.Name = "BTRFDataSet";
                    reportSourceMain.Value = BOL.CautionTag.GetEmptyBtrfDataSet().Tables[0];

                    Assembly assembly = Assembly.LoadFrom("Reports.dll");
                    Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodTransfusionRecordForm.BloodTransfusionRecordForm.rdlc");

                    LocalReport report = new LocalReport();
                    report.DataSources.Add(reportSourceMain);
                    report.LoadReportDefinition(stream);
                    report.DisplayName = "BTRF";
                    //CR 3362 
				    settings.Copies = System.Convert.ToInt16(this.updNumberOfForms.Value);

				    using (var reportPrinter = new BOL.VbecsReportPrinter(settings, false, report))
				    {
                        reportPrinter.Print();
				    }
			
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.PrintSuccess());
				}
			}
			catch(System.Threading.ThreadAbortException)
			{
				// BR_44.04
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.BTRFPrintingInterrupted(countBTRFs));
			}
			catch(System.Exception)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.BTRFGeneralPrintingProblem());
			}
		}

		#endregion

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgPrintBackupForms_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnOK.EnabledButton == false)
			{
				textToSpeak = this.ttToolTip.GetToolTip(this.btnOK);
			}

			this.SpeakMessage( textToSpeak );		
		}

	}
}

